#!/bin/bash

# This script is only for 24.04
if [[ ! $(lsb_release -sr 2>/dev/null) = "24.04" ]]; then
	echo "This script is only for Ubuntu 24.04"
	exit 1
fi

if [[ -d "/home/xui" ]]; then
	echo "XUI is already install, do you wan't to reinstall and loose all xui data ? (Y / N)"
	read choice
	if [[ ! "$choice" = "Y" ]]; then
		exit
	fi

	systemctl stop xuione.service
	systemctl disable xuione.service
	umount /home/xui/content/streams /home/xui/tmp
	rm -rf /home/xui /etc/systemd/system/xuione.service /etc/init.d/xuione
	sed -i '\/home\/xui/d' /etc/fstab
fi

# Install libssl
curl -sL 'http://archive.ubuntu.com/ubuntu/pool/main/o/openssl/libssl1.1_1.1.1f-1ubuntu2_amd64.deb' -o libssl1.1_1.1.1f-1ubuntu2_amd64.deb
dpkg -i libssl1.1_1.1.1f-1ubuntu2_amd64.deb
rm libssl1.1_1.1.1f-1ubuntu2_amd64.deb

# Install all package require for XUI
apt install software-properties-common apt-transport-https curl cpufrequtils iproute2 net-tools dirmngr gpg-agent software-properties-common libmaxminddb0 libmaxminddb-dev mmdb-bin libcurl4 libgeoip-dev libxslt1-dev libonig-dev e2fsprogs wget mariadb-server sysstat alsa-utils v4l-utils mcrypt certbot iptables-persistent libjpeg-dev libpng-dev php-ssh2 xz-utils zip unzip -y

# Create user xui
if [[ ! $(id xui 2>/dev/null) ]]; then
	adduser --system --shell /bin/false --group --disabled-login xui
fi

# Unzip xui package
mkdir /home/xui
tar -zxf "./xui.tar.gz" -C "/home/xui/"

# Setup mariadb
rm -rf /usr/bin/mysql
ln -s /usr/bin/mariadb /usr/bin/mysql
mariadb_config='# XUI\n[client]\nport                            = 3306\n\n[mysqld_safe]\nnice                            = 0\n\n[mysqld]\nuser                            = mysql\nport                            = 3306\nbasedir                         = /usr\ndatadir                         = /var/lib/mysql\ntmpdir                          = /tmp\nlc-messages-dir                 = /usr/share/mysql\nskip-external-locking\nskip-name-resolve\nbind-address                    = *\n\nkey_buffer_size                 = 128M\nmyisam_sort_buffer_size         = 4M\nmax_allowed_packet              = 64M\nmyisam-recover-options          = BACKUP\nmax_length_for_sort_data        = 8192\nquery_cache_limit               = 0\nquery_cache_size                = 0\nquery_cache_type                = 0\nexpire_logs_days                = 10\nmax_binlog_size                 = 100M\nmax_connections                 = 8192\nback_log                        = 4096\nopen_files_limit                = 20240\ninnodb_open_files               = 20240\nmax_connect_errors              = 3072\ntable_open_cache                = 4096\ntable_definition_cache          = 4096\ntmp_table_size                  = 1G\nmax_heap_table_size             = 1G\n\ninnodb_buffer_pool_size         = 10G\ninnodb_buffer_pool_instances    = 10\ninnodb_read_io_threads          = 64\ninnodb_write_io_threads         = 64\ninnodb_thread_concurrency       = 0\ninnodb_flush_log_at_trx_commit  = 0\ninnodb_flush_method             = O_DIRECT\nperformance_schema              = 0\ninnodb-file-per-table           = 1\ninnodb_io_capacity              = 20000\ninnodb_table_locks              = 0\ninnodb_lock_wait_timeout        = 0\n\nsql_mode                        = "NO_ENGINE_SUBSTITUTION"\n\n[mariadb]\n\nthread_cache_size               = 8192\nthread_handling                 = pool-of-threads\nthread_pool_size                = 12\nthread_pool_idle_timeout        = 20\nthread_pool_max_threads         = 1024\n\n[mysqldump]\nquick\nquote-names\nmax_allowed_packet              = 16M\n\n[mysql]\n\n[isamchk]\nkey_buffer_size                 = 16M'
echo -e "$mariadb_config" > /etc/mysql/my.cnf
systemctl restart mariadb
mariadb_username=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | head -c 32)
mariadb_password=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | head -c 32)
mysql -u root -e "DROP DATABASE IF EXISTS xui; CREATE DATABASE IF NOT EXISTS xui;"
mysql -u root -e "DROP DATABASE IF EXISTS xui_migrate; CREATE DATABASE IF NOT EXISTS xui_migrate;"
mysql -u root xui < "/home/xui/bin/install/database.sql"
mysql -u root -e "CREATE USER '$mariadb_username'@'localhost' IDENTIFIED BY '$mariadb_password';"
mysql -u root -e "GRANT ALL PRIVILEGES ON xui.* TO '$mariadb_username'@'localhost';"
mysql -u root -e "GRANT ALL PRIVILEGES ON xui_migrate.* TO '$mariadb_username'@'localhost';"
mysql -u root -e "GRANT ALL PRIVILEGES ON mysql.* TO '$mariadb_username'@'localhost';"
mysql -u root -e "GRANT GRANT OPTION ON xui.* TO '$mariadb_username'@'localhost';"
mysql -u root -e "CREATE USER '$mariadb_username'@'127.0.0.1' IDENTIFIED BY '$mariadb_password';"
mysql -u root -e "GRANT ALL PRIVILEGES ON xui.* TO '$mariadb_username'@'127.0.0.1';"
mysql -u root -e "GRANT ALL PRIVILEGES ON xui_migrate.* TO '$mariadb_username'@'127.0.0.1';"
mysql -u root -e "GRANT ALL PRIVILEGES ON mysql.* TO '$mariadb_username'@'127.0.0.1';"
mysql -u root -e "GRANT GRANT OPTION ON xui.* TO '$mariadb_username'@'127.0.0.1';"
mysql -u root -e "FLUSH PRIVILEGES;"

# Setup xui
xui_config='; XUI Configuration\n; -----------------\n; Your username and password will be encrypted and\n; saved to the credentials file in this folder\n; automatically.\n;\n; To change your username or password, modify BOTH\n; below and XUI will read and re-encrypt them.\n\n[XUI]\nhostname    =   "127.0.0.1"\ndatabase    =   "xui"\nport        =   3306\nserver_id   =   1\nlicense     =   ""\n\n[Encrypted]\nusername    =   "'$mariadb_username'"\npassword    =   "'$mariadb_password'"'
echo -e "$xui_config" > /home/xui/config/config.ini
echo "tmpfs /home/xui/content/streams tmpfs defaults,noatime,nosuid,nodev,noexec,mode=1777,size=90% 0 0" >> /etc/fstab
echo "tmpfs /home/xui/tmp tmpfs defaults,noatime,nosuid,nodev,noexec,mode=1777,size=6G 0 0" >> /etc/fstab
openssl req -x509 -nodes -days 3652 -newkey rsa:4096 -out /home/xui/bin/nginx/conf/custom-cert.crt -keyout /home/xui/bin/nginx/conf/custom-key.key -subj "/O=Generated/OU=Generated/CN=xui.local" > /dev/null 2>&1

xui_systemctl='[Unit]\nSourcePath=/home/xui/service\nDescription=XUI.one Service\nAfter=network.target\nStartLimitIntervalSec=0\n\n[Service]\nType=simple\nUser=root\nRestart=always\nRestartSec=1\nExecStart=/bin/bash /home/xui/service start\nExecRestart=/bin/bash /home/xui/service restart\nExecStop=/bin/bash /home/xui/service stop\n\n[Install]\nWantedBy=multi-user.target'
echo -e "$xui_systemctl" > /etc/systemd/system/xuione.service
chmod +x /etc/systemd/system/xuione.service
echo "Custom sysctl.conf - If you have your own custom sysctl.conf, type N or it will be overwritten. If you don't know what a sysctl configuration is, type Y as it will correctly set your TCP settings and open file limits."
echo "Overwrite sysctl configuration? Recommended! (Y / N): "
read choice
if [[ "$choice" = "Y" ]]; then
	# Empty if no error
	if [[ ! $(modprobe ip_conntrack) ]]; then
		xui_network_config='# XUI.one\n\nnet.ipv4.tcp_congestion_control = bbr\nnet.core.default_qdisc = fq\nnet.ipv4.tcp_rmem = 8192 87380 134217728\nnet.ipv4.udp_rmem_min = 16384\nnet.core.rmem_default = 262144\nnet.core.rmem_max = 268435456\nnet.ipv4.tcp_wmem = 8192 65536 134217728\nnet.ipv4.udp_wmem_min = 16384\nnet.core.wmem_default = 262144\nnet.core.wmem_max = 268435456\nnet.core.somaxconn = 1000000\nnet.core.netdev_max_backlog = 250000\nnet.core.optmem_max = 65535\nnet.ipv4.tcp_max_tw_buckets = 1440000\nnet.ipv4.tcp_max_orphans = 16384\nnet.ipv4.ip_local_port_range = 2000 65000\nnet.ipv4.tcp_no_metrics_save = 1\nnet.ipv4.tcp_slow_start_after_idle = 0\nnet.ipv4.tcp_fin_timeout = 15\nnet.ipv4.tcp_keepalive_time = 300\nnet.ipv4.tcp_keepalive_probes = 5\nnet.ipv4.tcp_keepalive_intvl = 15\nfs.file-max=20970800\nfs.nr_open=20970800\nfs.aio-max-nr=20970800\nnet.ipv4.tcp_timestamps = 1\nnet.ipv4.tcp_window_scaling = 1\nnet.ipv4.tcp_mtu_probing = 1\nnet.ipv4.route.flush = 1\nnet.ipv6.route.flush = 1'
		echo -e "$xui_network_config" > /etc/sysctl.conf
		echo "" > /home/xui/config/sysctl.on
		sysctl -p > /dev/null 2>&1
	fi
else
	sed -i '/DefaultLimitNOFILE/d' /etc/systemd/system.conf
	sed -i '/DefaultLimitNOFILESoft/d' /etc/systemd/system.conf
	echo "DefaultLimitNOFILE=1048576" >> /etc/systemd/system.conf
	echo "DefaultLimitNOFILESoft=1048576" >> /etc/systemd/system.conf
fi

# Setup redis
redis_config="bind *\nprotected-mode yes\nport 6379\ntcp-backlog 511\ntimeout 0\ntcp-keepalive 300\ndaemonize yes\nsupervised no\npidfile /home/xui/bin/redis/redis-server.pid\nloglevel warning\nlogfile /home/xui/bin/redis/redis-server.log\ndatabases 1\nalways-show-logo yes\nstop-writes-on-bgsave-error no\nrdbcompression no\nrdbchecksum no\ndbfilename dump.rdb\ndir /home/xui/bin/redis/\nslave-serve-stale-data yes\nslave-read-only yes\nrepl-diskless-sync no\nrepl-diskless-sync-delay 5\nrepl-disable-tcp-nodelay no\nslave-priority 100\nrequirepass #PASSWORD#\nmaxclients 655350\nlazyfree-lazy-eviction no\nlazyfree-lazy-expire no\nlazyfree-lazy-server-del no\nslave-lazy-flush no\nappendonly no\nappendfilename \"appendonly.aof\"\nappendfsync everysec\nno-appendfsync-on-rewrite no\nauto-aof-rewrite-percentage 100\nauto-aof-rewrite-min-size 64mb\naof-load-truncated yes\naof-use-rdb-preamble no\nlua-time-limit 5000\nslowlog-log-slower-than 10000\nslowlog-max-len 128\nlatency-monitor-threshold 0\nnotify-keyspace-events \"\"\nhash-max-ziplist-entries 512\nhash-max-ziplist-value 64\nlist-max-ziplist-size -2\nlist-compress-depth 0\nset-max-intset-entries 512\nzset-max-ziplist-entries 128\nzset-max-ziplist-value 64\nhll-sparse-max-bytes 3000\nactiverehashing yes\nclient-output-buffer-limit normal 0 0 0\nclient-output-buffer-limit slave 256mb 64mb 60\nclient-output-buffer-limit pubsub 32mb 8mb 60\nhz 10\naof-rewrite-incremental-fsync yes\nsave 60 1000\nserver-threads 4\nserver-thread-affinity true"
echo -e "$redis_config" > /home/xui/bin/redis/redis.conf

# Access Code
access_code=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | head -c 16)
mysql -u root -e "USE xui; INSERT INTO access_codes(code, type, enabled, groups) VALUES('$access_code', 0, 1, '[1]');"
cp /home/xui/bin/nginx/conf/codes/template /home/xui/bin/nginx/conf/codes/$access_code.conf
sed -i 's/#WHITELIST#//g' /home/xui/bin/nginx/conf/codes/$access_code.conf
sed -i 's/#TYPE#/admin/g' /home/xui/bin/nginx/conf/codes/$access_code.conf
sed -i 's/#CODE#/'$access_code'/g' /home/xui/bin/nginx/conf/codes/$access_code.conf
sed -i 's/#BURST#/500/g' /home/xui/bin/nginx/conf/codes/$access_code.conf

# Create a self-signed certificate
openssl req -x509 -nodes -days 3652 -newkey rsa:4096 -out /home/xui/bin/nginx/conf/custom-cert.crt -keyout /home/xui/bin/nginx/conf/custom-key.key -subj "/O=Generated/OU=Generated/CN=xui.local" > /dev/null 2>&1
echo 'ssl_certificate /home/xui/bin/nginx/conf/custom-cert.crt; ssl_certificate_key /home/xui/bin/nginx/conf/custom-key.key; ssl_protocols TLSv1.2 TLSv1.3;' > /home/xui/bin/nginx/conf/ssl.conf
chown xui:xui /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key /home/xui/bin/nginx/conf/ssl.conf
chmod 755 /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key
chmod 750 /home/xui/bin/nginx/conf/ssl.conf

# Start xui
chown xui:xui -R /home/xui
systemctl daemon-reload
mount -a
systemctl enable xuione

sleep 10
/home/xui/status 1 > /dev/null 2>&1
/home/xui/bin/php/bin/php /home/xui/includes/cli/startup.php > /dev/null 2>&1
echo -e "MariaDB Username: $mariadb_username\nMariaDB Password: $mariadb_password" > credentials.txt
/home/xui/status > /dev/null 2>&1
systemctl restart xuione

echo "Installation successfully finish"
server_ip=$(curl -sL "ifconfig.me")
echo "Xui is available at this URL : https://$server_ip/$access_code"
echo "Please save the content of credentials.txt somewhere"