#!/bin/bash

create_certificate() {
	if [[ $(ls /etc/letsencrypt/renewal/ 2>/dev/null) ]]; then
		echo "There is actually certificate setup, restart this script and delete old certificate"
		exit 1
	fi

	# Ask domain to user
	read -rep $'Please enter domain name :\n' DOMAIN

	# Copy and edit post-script for certbot
	cp /home/xui/custom-scripts/certificate/xui_nginx_reload.sh /etc/letsencrypt/renewal-hooks/post/xui_nginx_reload.sh
	sed -i 's|DOMAIN=.*|DOMAIN="'$DOMAIN'"|g' /etc/letsencrypt/renewal-hooks/post/xui_nginx_reload.sh
	chmod +x /etc/letsencrypt/renewal-hooks/post/xui_nginx_reload.sh
	
	# Running certbot
	certbot certonly --agree-tos --expand --non-interactive --register-unsafely-without-email --webroot -w /home/xui/www/ --post-hook "/etc/letsencrypt/renewal-hooks/post/xui_nginx_reload.sh" -d $DOMAIN
	if [[ ! -f "/etc/letsencrypt/renewal/$DOMAIN.conf" ]]; then
		echo "Error durring creation of your certificate"
		exit 1
	fi

	echo "Success, the certificate gonna be refresh automaticly"
}

delete_certificate() {
	echo "Here is a list of domain that is already setup in certbot"
	certbot certificates

	# Ask domain to user
	read -rep $'Please enter domain name for certificate you wan\'t to delete :\n' DOMAIN

	if [[ $(certbot certificates |& grep "$DOMAIN") ]]; then
		certbot delete --cert-name $DOMAIN --non-interactive
		rm /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key /home/xui/bin/nginx/conf/custom-chain.pem

		# Create a self-signed certificate
		openssl req -x509 -nodes -days 3652 -newkey rsa:4096 -out /home/xui/bin/nginx/conf/custom-cert.crt -keyout /home/xui/bin/nginx/conf/custom-key.key -subj "/O=Generated/OU=Generated/CN=xui.local" > /dev/null 2>&1
		echo 'ssl_certificate /home/xui/bin/nginx/conf/custom-cert.crt; ssl_certificate_key /home/xui/bin/nginx/conf/custom-key.key; ssl_protocols TLSv1.2 TLSv1.3;' > /home/xui/bin/nginx/conf/ssl.conf

		# Apply good permission
		chown xui:xui /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key /home/xui/bin/nginx/conf/custom-chain.pem /home/xui/bin/nginx/conf/ssl.conf
		chmod 755 /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key /home/xui/bin/nginx/conf/custom-chain.pem
		chmod 750 /home/xui/bin/nginx/conf/ssl.conf

		# Reload nginx to use new cert (no downtime)
		/home/xui/bin/nginx/sbin/nginx -s reload
	else
		echo "Domain certificate not found"
		exit 1
	fi

	echo "Success, domain certificate have been deleted"
}

certbot > /dev/null 2>&1
echo -e "Enter your choice :
1) Create certificate
2) Delete certificate"

read choice
case $choice in
	1)
		create_certificate
		;;
	2)
		delete_certificate
		;;
esac