#!/bin/bash
# This script is for certbot only, do not run this

DOMAIN=""

# Apply new certificate
cat /etc/letsencrypt/live/$DOMAIN/fullchain.pem > /home/xui/bin/nginx/conf/custom-cert.crt
cat /etc/letsencrypt/live/$DOMAIN/privkey.pem > /home/xui/bin/nginx/conf/custom-key.key
cat /etc/letsencrypt/live/$DOMAIN/chain.pem > /home/xui/bin/nginx/conf/custom-chain.pem

# Make sure ssl.conf is correct
echo 'ssl_certificate /home/xui/bin/nginx/conf/custom-cert.crt;
ssl_certificate_key /home/xui/bin/nginx/conf/custom-key.key;
ssl_trusted_certificate /home/xui/bin/nginx/conf/custom-chain.pem;

ssl_protocols TLSv1.2 TLSv1.3;
ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384;
ssl_prefer_server_ciphers off;
ssl_ecdh_curve auto;
ssl_session_timeout 10m;
ssl_session_cache shared:MozSSL:10m;
ssl_session_tickets off;' > /home/xui/bin/nginx/conf/ssl.conf

# Apply good permission
chown xui:xui /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key /home/xui/bin/nginx/conf/custom-chain.pem /home/xui/bin/nginx/conf/ssl.conf
chmod 755 /home/xui/bin/nginx/conf/custom-cert.crt /home/xui/bin/nginx/conf/custom-key.key /home/xui/bin/nginx/conf/custom-chain.pem
chmod 750 /home/xui/bin/nginx/conf/ssl.conf

# Reload nginx to use new cert (no downtime)
/home/xui/bin/nginx/sbin/nginx -s reload